unit CompEllipse;

interface

uses Classes, Forms, Graphics, Windows,
     Face;

type
  tEllipse = class(tDrawComponent)
  private
  public
    constructor CreateBy(aOwner: tComponent); override;
    constructor CreateByPoint(aOwner: tComponent; aPoint: tPoint); override;
    function GetRgn: hRgn; override;
    procedure Paint; override;
  end;

var dciEllipse: Integer;

implementation

uses Dialogs, SysUtils;

constructor tEllipse.CreateBy(aOwner: tComponent);
begin
  ImageIndex:= 13;
  inherited CreateByBasicName(aOwner, 'Ellipse');
  Color:= clHotLight;
  CreatingByAddPoint:= True;
end;

constructor tEllipse.CreateByPoint(aOwner: tComponent; aPoint: Windows.tPoint);
begin
  CreateBy(aOwner);
  Left:= aPoint.X;
  Top:= aPoint.Y;
end;

function tEllipse.GetRgn: hRgn;
begin
  Result:= CreateEllipticRgn(Round(Left* DrawFace.ZoomFactor)- DrawFace.Shift.X,
            Round(Top* DrawFace.ZoomFactor)- DrawFace.Shift.Y,
            Round((Left+ Width)* DrawFace.ZoomFactor)- DrawFace.Shift.X,
            Round((Top+ Height)* DrawFace.ZoomFactor)- DrawFace.Shift.Y);
end;

procedure tEllipse.Paint;
begin
  with DrawFace.Canvas do
  begin
    Brush.Color:= Color;
    Brush.Style:= bsSolid;
    Pen.Width:= Round(DrawFace.ZoomFactor* LineWidth);
    if Pen.Width< 1 then Pen.Width:= 1;
    if DrawFace.Printing then Pen.Color:= clBlack
                         else Pen.Color:= LineColor;
    Ellipse(Round(Left* DrawFace.ZoomFactor)- DrawFace.Shift.X,
            Round(Top * DrawFace.ZoomFactor)- DrawFace.Shift.Y,
            Round((Left+ Width)* DrawFace.ZoomFactor)- DrawFace.Shift.X,
            Round((Top+ Height)* DrawFace.ZoomFactor)- DrawFace.Shift.Y);
  end;
  inherited;
end;

initialization

  //dci -> DrawComponentIndex

  dciEllipse:= DrawCompItemList.Add(tDrawCompItem.Create('Ellipse', tEllipse));

end.
